/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.entity.block;

import com.nhoryzon.mc.farmersdelight.FarmersDelightMod;
import com.nhoryzon.mc.farmersdelight.block.BasketBlock;
import com.nhoryzon.mc.farmersdelight.registry.BlockEntityTypesRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2615;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class BasketBlockEntity
extends class_2621
implements class_2615 {
    public static final String TAG_KEY_TRANSFER_COOLDOWN = "TransferCooldown";
    private static final class_265[] COLLECTION_AREA_SHAPES = new class_265[]{class_2248.method_9541((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)-16.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)32.0), class_2248.method_9541((double)-16.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0)};
    private static final int MAX_INVENTORY_SIZE = 27;
    private class_2371<class_1799> content = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private int transferCooldown = -1;

    protected BasketBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState) {
        super(type, blockPos, blockState);
    }

    public static boolean pullItems(class_1937 world, BasketBlockEntity basket, int facingIndex) {
        for (class_1542 itementity : BasketBlockEntity.getCaptureItems(world, basket, facingIndex)) {
            if (!BasketBlockEntity.captureItem((class_1263)basket, itementity)) continue;
            return true;
        }
        return false;
    }

    public static class_1799 putStackInInventoryAllSlots(class_1263 destination, class_1799 stack) {
        int i = destination.method_5439();
        for (int j = 0; j < i && !stack.method_7960(); ++j) {
            stack = BasketBlockEntity.insertStack(destination, stack, j);
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(class_1263 inventoryIn, class_1799 stack, int index) {
        class_1278 sidedInventory;
        if (!inventoryIn.method_5437(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof class_1278) || (sidedInventory = (class_1278)inventoryIn).method_5492(index, stack, null);
    }

    private static boolean canCombine(class_1799 stack1, class_1799 stack2) {
        if (stack1.method_7909() != stack2.method_7909()) {
            return false;
        }
        if (stack1.method_7919() != stack2.method_7919()) {
            return false;
        }
        if (stack1.method_7947() > stack1.method_7914()) {
            return false;
        }
        return class_1799.method_7975((class_1799)stack1, (class_1799)stack2);
    }

    private static class_1799 insertStack(class_1263 destination, class_1799 stack, int index) {
        class_1799 itemstack = destination.method_5438(index);
        if (BasketBlockEntity.canInsertItemInSlot(destination, stack, index)) {
            boolean flag = false;
            boolean isDestinationEmpty = destination.method_5442();
            if (itemstack.method_7960()) {
                destination.method_5447(index, stack);
                stack = class_1799.field_8037;
                flag = true;
            } else if (BasketBlockEntity.canCombine(itemstack, stack)) {
                int i = stack.method_7914() - itemstack.method_7947();
                int j = Math.min(stack.method_7947(), i);
                stack.method_7934(j);
                itemstack.method_7933(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                BasketBlockEntity firstBasket;
                if (isDestinationEmpty && destination instanceof BasketBlockEntity && !(firstBasket = (BasketBlockEntity)destination).mayTransfer()) {
                    int k = 0;
                    firstBasket.setTransferCooldown(8 - k);
                }
                destination.method_5431();
            }
        }
        return stack;
    }

    public static boolean captureItem(class_1263 inventory, class_1542 itemEntity) {
        boolean flag = false;
        class_1799 groundItemStack = itemEntity.method_6983().method_7972();
        class_1799 itemStackCatch = BasketBlockEntity.putStackInInventoryAllSlots(inventory, groundItemStack);
        if (itemStackCatch.method_7960()) {
            flag = true;
            itemEntity.method_5650(class_1297.class_5529.field_26999);
        } else {
            itemEntity.method_6979(itemStackCatch);
        }
        return flag;
    }

    public static List<class_1542> getCaptureItems(class_1937 world, BasketBlockEntity basket, int facingIndex) {
        return world == null ? new ArrayList<class_1542>() : basket.getFacingCollectionArea(facingIndex).method_1090().stream().flatMap(boundingBoxe -> world.method_8390(class_1542.class, boundingBoxe.method_989(basket.method_11266() - 0.5, basket.method_11264() - 0.5, basket.method_11265() - 0.5), class_1301.field_6154).stream()).toList();
    }

    public BasketBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(BlockEntityTypesRegistry.BASKET.get(), blockPos, blockState);
    }

    protected class_2371<class_1799> method_11282() {
        return this.content;
    }

    protected void method_11281(class_2371<class_1799> content) {
        this.content = content;
    }

    protected class_2561 method_17823() {
        return FarmersDelightMod.i18n("container.basket", new Object[0]);
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return class_1707.method_19245((int)syncId, (class_1661)playerInventory, (class_1263)this);
    }

    public int method_5439() {
        return this.content.size();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        class_1262.method_5426((class_2487)nbtCompound, this.content);
        return nbtCompound;
    }

    public double method_11266() {
        return (double)this.method_11016().method_10263() + 0.5;
    }

    public double method_11264() {
        return (double)this.method_11016().method_10264() + 0.5;
    }

    public double method_11265() {
        return (double)this.method_11016().method_10260() + 0.5;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, BasketBlockEntity blockEntity) {
        if (world != null && !world.method_8608()) {
            --blockEntity.transferCooldown;
            if (blockEntity.isNotInTransferCooldown()) {
                blockEntity.setTransferCooldown(0);
                int facing = ((class_2350)blockEntity.method_11010().method_11654((class_2769)BasketBlock.FACING)).method_10146();
                blockEntity.updateHopper(() -> BasketBlockEntity.pullItems(world, blockEntity, facing));
            }
        }
    }

    public class_1799 method_5434(int slot, int amount) {
        this.method_11289(null);
        return class_1262.method_5430(this.method_11282(), (int)slot, (int)amount);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.method_11289(null);
        this.method_11282().set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (!this.method_11286(tag)) {
            class_1262.method_5426((class_2487)tag, this.content);
        }
        tag.method_10569(TAG_KEY_TRANSFER_COOLDOWN, this.transferCooldown);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.content = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_11283(tag)) {
            class_1262.method_5429((class_2487)tag, this.content);
        }
        this.transferCooldown = tag.method_10550(TAG_KEY_TRANSFER_COOLDOWN);
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isNotInTransferCooldown() {
        return this.transferCooldown <= 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    private void updateHopper(BooleanSupplier supplier) {
        if (this.field_11863 != null && !this.field_11863.method_8608() && this.isNotInTransferCooldown() && Boolean.TRUE.equals(this.method_11010().method_11654((class_2769)BasketBlock.ENABLED))) {
            boolean flag = false;
            if (!this.isFull()) {
                flag = supplier.getAsBoolean();
            }
            if (flag) {
                this.setTransferCooldown(8);
                this.method_5431();
            }
        }
    }

    private boolean isFull() {
        for (class_1799 itemstack : this.content) {
            if (!itemstack.method_7960() && itemstack.method_7947() == itemstack.method_7914()) continue;
            return false;
        }
        return true;
    }

    private class_265 getFacingCollectionArea(int facingIndex) {
        return COLLECTION_AREA_SHAPES[facingIndex];
    }
}

